<?php
// check_session.php

$base = 'https://v.centrx.eu/session.php';
$tests = [
    ''              => 'Ошибка: не указан session',
    'ABC123'        => '<div id="root">',   // в PWA-странице будет элемент <div id="root">
    'INVALID_ID'    => 'Сессия не найдена',
];

foreach ($tests as $id => $expect) {
    $url = $base . ($id !== '' ? '?id=' . $id : '');
    $response = @file_get_contents($url);
    if ($response === false) {
        echo "[$id]: не удалось получить ответ от $url\n";
        continue;
    }
    if (strpos($response, $expect) !== false) {
        echo "[$id]: ✅ найдено ожидаемое \"$expect\"\n";
    } else {
        echo "[$id]: ❌ НЕ найдено \"$expect\". Вот часть ответа:\n";
        echo substr($response, 0, 200) . "\n\n";
    }
}
