<?php
// create_user.php
header('Content-Type: application/json');
require_once __DIR__ . '/config/db.php';

// Получаем тело запроса
$body = file_get_contents('php://input');
$data = json_decode($body, true);

// Проверяем JSON
if (!is_array($data)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'Invalid JSON']);
    exit;
}

// Обязательные поля
$required = ['name','email','password','phone','role'];
foreach ($required as $field) {
    if (empty($data[$field])) {
        http_response_code(400);
        echo json_encode(['success'=>false,'error'=>'Missing field: '.$field]);
        exit;
    }
}

// Подготовка значений
$name  = trim($data['name']);
$email = trim($data['email']);
$phone = trim($data['phone']);
$role  = trim($data['role']);
$password = $data['password']; // сырое

// Проверка роли
$validRoles = ['admin','driver','client'];
if (!in_array($role, $validRoles)) {
    http_response_code(400);
    echo json_encode(['success'=>false,'error'=>'Invalid role']);
    exit;
}
// Хешируем пароль
$hash = password_hash($password, PASSWORD_DEFAULT);

try {
    // Вставляем пользователя
    $stmt = $pdo->prepare(
        'INSERT INTO users (name,email,password_hash,phone,role) VALUES (:name,:email,:hash,:phone,:role)'
    );
    $stmt->execute([
        ':name' => $name,
        ':email' => $email,
        ':hash' => $hash,
        ':phone' => $phone,
        ':role' => $role
    ]);
    $userId = $pdo->lastInsertId();
    echo json_encode(['success'=>true,'user_id'=>$userId]);
} catch (PDOException $e) {
    http_response_code(500);
    // Дубли почты даёт ошибку уникального индекса
    echo json_encode(['success'=>false,'error'=>$e->getMessage()]);
}
