<?php
// /home/jwfnsshf/v.centrx.eu/get_messages.php
header('Content-Type: application/json; charset=UTF-8');

$sessionsFile = __DIR__ . '/sessions.json';
$sessionId    = $_GET['session']  ?? '';
$lastId       = intval($_GET['last_id'] ?? 0);

if (!$sessionId) {
    http_response_code(400);
    echo json_encode(['error' => 'Не указан session']);
    exit;
}

if (!file_exists($sessionsFile)) {
    http_response_code(500);
    echo json_encode(['error' => 'sessions.json не найден']);
    exit;
}

$sessionsJson = file_get_contents($sessionsFile);
$sessions = json_decode($sessionsJson, true);
if (!is_array($sessions)) {
    http_response_code(500);
    echo json_encode(['error' => 'Неверный формат sessions.json']);
    exit;
}

if (!isset($sessions[$sessionId])) {
    http_response_code(404);
    echo json_encode(['error' => 'Сессия не найдена']);
    exit;
}

// ВНИМАНИЕ: ваши поля в sessions.json называются A_lang и B_lang
$langA = $sessions[$sessionId]['A_lang'] ?? null;
$langB = $sessions[$sessionId]['B_lang'] ?? null;

// Собираем все сообщения с id > last_id
$allMessages = $sessions[$sessionId]['messages'] ?? [];
$newMessages = [];
foreach ($allMessages as $msg) {
    if (isset($msg['id']) && intval($msg['id']) > $lastId) {
        $newMessages[] = $msg;
    }
}

// Возвращаем JSON с полями languages и messages
echo json_encode([
    'languages' => [
        'A' => $langA,
        'B' => $langB
    ],
    'messages' => $newMessages
], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
