<?php
// modules/excursions/backend/api/admin_routes.php
// Административный API: список и удаление экскурсий

// Отображаем PHP-ошибки
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header('Content-Type: application/json; charset=utf-8');

// Подключаем PDO
require '/home/jwfnsshf/v.centrx.eu/config/db.php'; // абсолютный путь к файлу

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    // Получаем все экскурсии
    $stmt = $pdo->query("SELECT id, name, duration, status, country, city, updated_at FROM routes ORDER BY updated_at DESC");
    $routes = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $row['languages'] = [];
        $routes[] = $row;
    }
    echo json_encode($routes, JSON_UNESCAPED_UNICODE);
    exit;
}

if ($method === 'DELETE') {
    if (empty($_GET['id'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Missing id']);
        exit;
    }
    $id = (int)$_GET['id'];
    $stmt = $pdo->prepare('DELETE FROM routes WHERE id = :id');
    $stmt->execute(['id' => $id]);
    http_response_code(204);
    exit;
}

// Прочие методы
http_response_code(405);
echo json_encode(['error' => 'Method not allowed']);
