<?php
// /home/jwfnsshf/v.centrx.eu/register_language.php
header('Content-Type: application/json; charset=UTF-8');

$sessionsFile = __DIR__ . '/sessions.json';

// Считываем JSON-тело запроса
$payload = json_decode(file_get_contents('php://input'), true);
$sessionId = trim($payload['session'] ?? '');
$lang      = trim($payload['lang'] ?? '');
$side      = strtoupper(trim($payload['side'] ?? ''));

// Валидация: должны быть session, side=A|B, lang
if ($sessionId === '' || ($side !== 'A' && $side !== 'B') || $lang === '') {
    http_response_code(400);
    echo json_encode(['error' => 'Не указаны session, side или lang, либо side не A/B']);
    exit;
}

// Убедимся, что sessions.json существует; если нет — создаём пустой массив
if (!file_exists($sessionsFile)) {
    file_put_contents($sessionsFile, json_encode([], JSON_UNESCAPED_UNICODE));
}

$json = file_get_contents($sessionsFile);
$sessions = json_decode($json, true);
if (!is_array($sessions)) {
    $sessions = [];
}

// Если записи для этой сессии нет — инициализируем её
if (!isset($sessions[$sessionId])) {
    $sessions[$sessionId] = [
        'langA' => null,
        'langB' => null,
        'messages' => []  // если у вас есть сообщения, сохраните здесь их вариант
    ];
}

// Работаем с записью
$entry = &$sessions[$sessionId];

// Сохраняем язык в нужное поле
if ($side === 'A') {
    $entry['langA'] = $lang;
    $partnerLang = $entry['langB'] ?? null;
} else { // side === 'B'
    $entry['langB'] = $lang;
    $partnerLang = $entry['langA'] ?? null;
}

// Проверяем, зарегистрированы ли оба
$bothRegistered = (!empty($entry['langA']) && !empty($entry['langB']));

// Сохраняем обратно в sessions.json
file_put_contents($sessionsFile,
    json_encode($sessions, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT)
);

// Возвращаем JSON-ответ
echo json_encode([
    'bothRegistered' => $bothRegistered,
    'partnerLang'    => $partnerLang
]);
