<?php
// /home/jwfnsshf/v.centrx.eu/session.php

// Проверяем, что передан параметр id и side
if (!isset($_GET['id']) || !$_GET['id'] || !isset($_GET['side']) || !in_array(strtoupper($_GET['side']), ['A', 'B'])) {
    echo 'Ошибка: не указан session или side';
    exit;
}

$sessionId = trim($_GET['id']);
$sideParam = strtoupper(trim($_GET['side']));

// Путь к файлу sessions.json (рядом с этим файлом)
$sessionsFile = __DIR__ . '/sessions.json';

if (!file_exists($sessionsFile)) {
    echo 'Ошибка: sessions.json не найден';
    exit;
}

$sessions = json_decode(file_get_contents($sessionsFile), true);

// Проверяем, что такая сессия зарегистрирована
if (!isset($sessions[$sessionId])) {
    echo 'Сессия не найдена';
    exit;
}
?>
<!DOCTYPE html>
<html lang="ru">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover">
  <title>Переводчик – сессия <?= htmlspecialchars($sessionId) ?></title>
  <link rel="stylesheet" href="/pwa/css/main.css">
</head>
<body>
  <!-- Элемент, куда PWA вставит интерфейс -->
  <div id="root"></div>

  <!-- Передаём session и side в JS -->
  <script>
    window.SESSION_ID = "<?= htmlspecialchars($sessionId, ENT_QUOTES) ?>";
    window.SIDE       = "<?= htmlspecialchars($sideParam, ENT_QUOTES) ?>";
  </script>

  <!-- Подключаем PWA-скрипт -->
  <script src="/pwa/js/main.js"></script>
</body>
</html>
