<?php
/**
 * Проверка SSL-сертификата домена
 * Usage: php check_ssl.php
 */

$host = 'v.centrx.eu';
$port = 443;
$timeout = 30;

// Создаём контекст с опцией capture_peer_cert
$contextOptions = [
    'ssl' => [
        'capture_peer_cert' => true,
        'verify_peer'       => false, // если хотите проверять цепочку доверия - true
        'verify_peer_name'  => false,
    ],
];
$context = stream_context_create($contextOptions);

// Открываем соединение
$client = @stream_socket_client(
    "ssl://{$host}:{$port}",
    $errno,
    $errstr,
    $timeout,
    STREAM_CLIENT_CONNECT,
    $context
);

if (!$client) {
    echo "Не удалось подключиться к {$host}:{$port} — {$errstr} ({$errno})\n";
    exit(1);
}

// Получаем ресурс сертификата
$params = stream_context_get_params($client);
if (!isset($params['options']['ssl']['peer_certificate'])) {
    echo "Сертификат не был получен.\n";
    exit(1);
}

/** @var resource $certResource */
$certResource = $params['options']['ssl']['peer_certificate'];

// Парсим сертификат
$certInfo = openssl_x509_parse($certResource, false);

if (!$certInfo) {
    echo "Не удалось распарсить сертификат.\n";
    exit(1);
}

// Вычисляем даты начала и конца действия
$validFrom  = date('Y-m-d H:i:s', $certInfo['validFrom_time_t']);
$validTo    = date('Y-m-d H:i:s', $certInfo['validTo_time_t']);
$daysRemain = floor(($certInfo['validTo_time_t'] - time()) / 86400);

// Издатель и владелец
$issuer  = $certInfo['issuer'];
$subject = $certInfo['subject'];

echo "Сертификат для {$host}:{$port}\n";
echo "  Издано:       " . ($issuer['O'] ?? implode(', ', $issuer)) . "\n";
echo "  Владелец:     " . ($subject['CN'] ?? implode(', ', $subject)) . "\n";
echo "  Действует с:  {$validFrom}\n";
echo "  Действует до: {$validTo}\n";
echo "  Осталось дней: {$daysRemain}\n";

fclose($client);
?>
