<?php
// /home/jwfnsshf/v.centrx.eu/admin/session_manager.php

$sessionsFile = __DIR__ . '/../sessions.json';

// Обработка кнопки «Очистить всё»
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['clear_sessions'])) {
    file_put_contents($sessionsFile, json_encode([], JSON_UNESCAPED_UNICODE));
    $message = 'Все сессии и диалоги очищены.';
}

// Функция для генерации случайного идентификатора сессии
function generateSessionId($length = 16) {
    return bin2hex(random_bytes((int)($length / 2)));
}

$newSessionId = null;
$driverLink    = null;
$passengerLink = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['create_session'])) {
    $newSessionId = generateSessionId(16);

    // Загрузка и инициализация sessions.json
    if (file_exists($sessionsFile)) {
        $data = json_decode(file_get_contents($sessionsFile), true);
        if (!is_array($data)) {
            $data = [];
        }
    } else {
        $data = [];
    }

    if (!isset($data[$newSessionId])) {
        $data[$newSessionId] = ['A_lang' => null, 'B_lang' => null];
        file_put_contents($sessionsFile, json_encode($data, JSON_UNESCAPED_UNICODE));
    }

    // Собираем полный URL, включая протокол и домен
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https://' : 'http://';
    $host     = $_SERVER['HTTP_HOST'];
    $baseUrl  = $protocol . $host . '/session.php';

    // Генерируем окончательные ссылки без лишних символов
    $driverLink    = $baseUrl . '?id=' . $newSessionId . '&side=A';
    $passengerLink = $baseUrl . '?id=' . $newSessionId . '&side=B';
}
?>
<!DOCTYPE html>
<html lang="ru">
<head>
  <meta charset="UTF-8">
  <title>Управление сессиями</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      margin: 2rem;
    }
    h1 {
      margin-bottom: 1rem;
    }
    .button {
      padding: 0.5rem 1rem;
      margin: 0.5rem 0;
      border: none;
      background-color: #4285f4;
      color: white;
      cursor: pointer;
      font-size: 1rem;
      border-radius: 4px;
    }
    .button:hover {
      background-color: #3367d6;
    }
    .notice {
      margin: 1rem 0;
      padding: 0.75rem 1rem;
      background-color: #e8f0fe;
      border-left: 4px solid #4285f4;
    }
    .links {
      margin: 1rem 0;
      padding: 1rem;
      background-color: #f1f3f4;
      border: 1px solid #dadce0;
      border-radius: 4px;
    }
    .links a {
      word-break: break-all;
      color: #1a73e8;
      text-decoration: none;
    }
    .links a:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>

  <h1>Админка: Управление сессиями</h1>

  <?php if (!empty($message)): ?>
    <div class="notice"><?= htmlspecialchars($message) ?></div>
  <?php endif; ?>

  <!-- Форма для генерации новой сессии -->
  <form method="post" style="margin-bottom: 2rem;">
    <button type="submit" name="create_session" class="button">Создать новую сессию</button>
  </form>

  <?php if ($newSessionId !== null): ?>
    <div class="links">
      <p><strong>ID сессии:</strong> <?= htmlspecialchars($newSessionId) ?></p>
      <p><strong>Ссылка для водителя (side=A):</strong><br>
        <a href="<?= htmlspecialchars($driverLink) ?>" target="_blank"><?= htmlspecialchars($driverLink) ?></a>
      </p>
      <p><strong>Ссылка для пассажира (side=B):</strong><br>
        <a href="<?= htmlspecialchars($passengerLink) ?>" target="_blank"><?= htmlspecialchars($passengerLink) ?></a>
      </p>
    </div>
  <?php endif; ?>

  <!-- Форма для очистки всех сессий и диалогов -->
  <form method="post">
    <button type="submit" name="clear_sessions" class="button" style="background-color: #d93025;">
      Очистить все сессии и диалоги
    </button>
  </form>

</body>
</html>
