<?php
// validate_keys.php
// Скрипт проверки формата VAPID-ключей
$config = require __DIR__ . '/config/webpush.php';
$pub = $config['vapid']['publicKey'];
$priv = $config['vapid']['privateKey'];

echo "PublicKey length: " . strlen($pub) . "\n";
echo preg_match('/^[A-Za-z0-9\-_]+$/', $pub)
     ? "PublicKey format OK\n"
     : "PublicKey format INVALID\n";

echo "PrivateKey length: " . strlen($priv) . "\n";
echo preg_match('/^[A-Za-z0-9\-_]+$/', $priv)
     ? "PrivateKey format OK\n"
     : "PrivateKey format INVALID\n";
