<?php
// modules/excursions/backend/api/test_db.php
// Тестовый скрипт для проверки подключения к базе и работы PHP

// Включаем отображение ошибок
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header('Content-Type: application/json; charset=utf-8');

try {
    // Подключаем файл конфигурации БД
    require '/home/jwfnsshf/v.centrx.eu/config/db.php'; // проверяемый путь
    // Debug
    // echo json_encode(['db_loaded'=>true]); exit; // путь к вашему db.php
    if (!isset($pdo) || !($pdo instanceof PDO)) {
        throw new Exception('PDO not available');
    }
    // Пробный запрос
    $stmt = $pdo->query('SELECT 1');
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    echo json_encode([
        'status' => 'success',
        'db_result' => $result
    ], JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}
