<?php
// modules/excursions/backend/save_route_geometry.php
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__ . '/../../../config/db.php';

// Получаем JSON из тела запроса
$body = json_decode(file_get_contents('php://input'), true);
$routeId  = isset($body['id']) ? (int)$body['id'] : 0;
$polyline = isset($body['polyline']) ? $body['polyline'] : '';

if (!$routeId || !$polyline) {
    http_response_code(400);
    echo json_encode(['success'=>false,'error'=>'Missing id or polyline']);
    exit;
}

try {
    // Обновляем поле polyline
    $stmt = $pdo->prepare('UPDATE routes SET polyline = :polyline, updated_at = NOW() WHERE id = :id');
    $stmt->execute([
        ':polyline' => $polyline,
        ':id'       => $routeId
    ]);
    echo json_encode(['success'=>true, 'route_id'=>$routeId]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success'=>false, 'error'=>$e->getMessage()]);
}
?>
