<?php
// send_sms.php
header('Content-Type: application/json');

require_once __DIR__ . '/config/db.php';
$config = require __DIR__ . '/config/sms.php';
$smsCfg = $config['smsclub'];

// Получаем входные данные
$body = json_decode(file_get_contents('php://input'), true);
$tripId = isset($body['trip_id']) ? (int)$body['trip_id'] : 0;
$event  = isset($body['event']) ? $body['event'] : 'start';

if (!$tripId) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'Missing trip_id']);
    exit;
}

// Получаем номер клиента из БД
$stmt = $pdo->prepare(
    'SELECT u.phone FROM trips t
     JOIN users u ON u.id = t.client_id
     WHERE t.id = :tripId'
);
$stmt->execute([':tripId' => $tripId]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$user) {
    http_response_code(404);
    echo json_encode(['success' => false, 'error' => 'Client not found']);
    exit;
}

// Определяем текст сообщения
switch ($event) {
    case 'start':
        $message = 'Ваш автомобиль выехал и в пути. Отслеживайте его на карте.';
        break;
    case 'arrived':
        $message = 'Ваш автомобиль прибыл. Выходите, пожалуйста.';
        break;
    default:
        $message = 'Информация о рейсе обновлена.';
}

// Формируем payload для SMSClub
$payload = [
    'src_addr'      => $smsCfg['src_addr'],
    'phone'         => [$user['phone']],  // API expects array under 'phone'
    'message'       => $message,
    'integration_id'=> $smsCfg['integration_id'],
];

// Отправляем SMS через cURL через cURL через cURL
$ch = curl_init($smsCfg['apiUrl']);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json; charset=utf-8',
    'Authorization: Bearer ' . $smsCfg['bearerToken']
]);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload, JSON_UNESCAPED_UNICODE));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// Записываем результат в таблицу notifications
$status = ($httpCode === 200 ? 'sent' : 'failed');
$stmt = $pdo->prepare(
    'INSERT INTO notifications (trip_id, type, status) VALUES (:tripId, :type, :status)'
);
$stmt->execute([
    ':tripId' => $tripId,
    ':type'   => 'sms',
    ':status' => $status
]);

// Возвращаем результат
echo json_encode([
    'success'  => $status === 'sent',
    'httpCode' => $httpCode,
    'response' => json_decode($response, true)
]);
